// The difference between this example and the example 1 is that at the end of its work the coroutine
// returns the number of rows it has read.
#include <coroutine>
class ReturnType
{
public:
	struct promise_type
	{
		int coro_result;
		auto get_return_object() { return ReturnType{ coroutine_handle<promise_type>::from_promise(*this) }; }
		auto initial_suspend() { return suspend_always(); }
		void unhandled_exception() { terminate(); }
		auto final_suspend() noexcept { return suspend_always(); }
		void return_value(const int& value)
		{
			coro_result = value;
		}
	};
	coroutine_handle<promise_type> handle;
	ReturnType(coroutine_handle<promise_type> h) : handle(h) {}
	~ReturnType() { handle.destroy(); } // method destroy() from class coroutine_handle<promise_type> destroys coroutine
	bool resume() const
	{
		if (!handle || handle.done())
		{
			return false;
		}
		handle.resume();
		return !handle.done();
	}
	int get_result() const
	{
		return handle.promise().coro_result;
	}
};

ReturnType coro_reader(fstream& f)
{
	cout << "started" << endl;
	int nSuspend = 0;
	char line[256];
	while (true)
	{
		f.getline(line, 256);
		if (f.eof())
		{
			cout << "No more data" << endl;
			break;
		}
		cout << "has read text: " << line << " lines" << endl;
		nSuspend++;
		cout << nSuspend << endl;
		co_await suspend_always();
	}
	cout << "ended" << endl;
	co_return nSuspend;
}

void Test()
{
	fstream File;
	File.open("C:\\Temp\\sometext.txt", fstream::in);
	if (!File.good())
	{
		cout << "Failed to open file" << endl;
		return;
	}
	ReturnType task = coro_reader(File);
	while (true)
	{
		cout << "Press a key to continue, ESC to stop" << endl;
		if (_getch() == 27)
		{
			break;  // ESC - stop reading from file
		}
		if (!task.resume())  // When coro_reader has suspended its work, resume it after keystroke
		{
			break;  // coroutine has exited
		}
	}
	cout << task.get_result() << endl;
	File.close();
}